﻿//////////////////////////////////////////////
// BitMaskCompressor.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkImages
{
	class ImageView ;

	enum class PIXEL_FORMAT ;

	struct AlignmentDescriptor ;
	struct ImageDescriptor ;
}

namespace nkImages::dds
{
	class DdsHeader ;
}

/// Includes ---------------------------------

// nkMemory
#include <NilkinsMemory/Containers/Buffer.h>
#include <NilkinsMemory/Containers/BufferView.h>

/// Class ------------------------------------

namespace nkImages::dds
{
	class DdsBitMaskCompressor final
	{
		public :

			// Decompression
			static nkMemory::Buffer decompress (const DdsHeader& header, nkMemory::BufferView<> dataView, nkMemory::BufferCast<ImageDescriptor>& images, const AlignmentDescriptor& alignmentDescriptor) ;
	} ;
}